#include <iostream>
#include <vector>
#include <cmath>
#include <map>

using namespace std;

#define int long long

vector<bool> used;

vector<vector<int>> G;
vector<int> path;
bool isOk = false;

void dfs(int v, int pred, int size) {
    if (v != 0) {
        used[v] = true;
    }
    if (v == 0 and size == G.size() + 1) {
        cout << "YES" << endl;
        isOk = true;
        for(int i=0;i<path.size();i++)
            cout<<path[i]+1<<" ";
        cout<<1<<endl;
        return;
    }
    path.push_back(v);
    for (auto x: G[v]) {
        if (x != pred and !used[x]) {
            if (x == 0) {
                if (size == G.size()) {
                    dfs(x, v, size + 1);
                }
            } else {
                dfs(x, v, size + 1);
            }
        }
    }
    path.pop_back();
    used[v] = false;
}

signed main() {
    int n, m;
    cin >> n >> m;
    G.resize(n);
    used.resize(n, false);
    for (int i = 0; i < m; ++i) {
        int a, b;
        cin >> a >> b;
        a--;
        b--;
        G[a].push_back(b);
    }
    dfs(0, -1, 1);
    if(!isOk)
    {
        cout<<"NO"<<endl;
    }
    return 0;
}
